/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Icon;
import java.awt.Color;
import java.awt.Graphics;

public class IconStudy
extends Icon {
    static final int L = 12;
    static String LOOK;
    private static final int[][] TX;
    private static final String[] MODE;

    protected IconStudy(Aladin aladin) {
        super(aladin, 32, 24);
        LOOK = Aladin.chaine.getString("LOOK");
    }

    protected void drawLook(Graphics g, int x, int y) {
        for (int i = 0; i < TX.length; ++i) {
            g.drawLine(TX[i][1] + x, TX[i][0] + y, TX[i][2] + x, TX[i][0] + y);
        }
    }

    @Override
    protected boolean isAvailable() {
        return !this.aladin.view.isFree();
    }

    @Override
    protected boolean isMouseIn() {
        return this.in;
    }

    @Override
    protected Color getLogoColor() {
        Color c;
        int mode = this.getMode();
        Color color = !this.isAvailable() ? Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE : (mode == 0 ? Aladin.COLOR_CONTROL_FOREGROUND : (mode == 1 ? Color.orange : (c = mode == 2 ? Aladin.COLOR_ICON_ACTIVATED : Aladin.COLOR_BLUE)));
        if (this.isMouseIn()) {
            c = c.brighter();
        }
        return c;
    }

    @Override
    protected void drawLogo(Graphics g) {
        super.drawLogo(g);
        int x = 10 + this.DX;
        int y = 0;
        int r = 10;
        if (this.isAvailable()) {
            g.setColor(this.getFillInColor());
            g.fillOval(x, y, r, r);
        }
        g.setColor(this.getLogoColor());
        this.drawLook(g, 10, 0);
        g.setColor(this.getLabelColor());
        g.setFont(Aladin.SPLAIN);
        g.drawString(LOOK, this.W / 2 - g.getFontMetrics().stringWidth(LOOK) / 2, this.H - 2);
    }

    protected int getMode() {
        boolean simbad = this.aladin.calque.flagSimbad;
        boolean vizier = this.aladin.calque.flagVizierSED;
        return simbad && vizier ? 2 : (simbad ? 1 : (vizier ? 3 : 0));
    }

    @Override
    protected void submit() {
        this.aladin.cycleLook();
    }

    @Override
    protected String getHelpTip() {
        if (!this.isAvailable()) {
            return Aladin.chaine.getString("LOOKTIP");
        }
        return MODE[this.getMode()] + " " + Aladin.chaine.getString("LOOKTIP1");
    }

    @Override
    protected String getHelpKey() {
        return "Look.HELP";
    }

    static {
        TX = new int[][]{{0, 3, 7}, {1, 2, 2}, {1, 8, 8}, {2, 1, 1}, {2, 9, 9}, {3, 0, 0}, {3, 4, 4}, {3, 9, 10}, {4, 0, 0}, {4, 3, 3}, {4, 10, 10}, {5, 0, 0}, {5, 10, 10}, {6, 0, 0}, {6, 10, 10}, {7, 0, 0}, {7, 10, 10}, {8, 1, 1}, {8, 9, 12}, {9, 2, 2}, {9, 8, 8}, {9, 10, 14}, {10, 3, 7}, {10, 11, 15}, {11, 12, 15}, {12, 14, 14}};
        MODE = new String[]{"No", "Simbad", "Simbad+VizieR", "VizieR"};
    }
}

